/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.toolkit.admin.search;

import filenet.vw.api.IVWTableDefinition;
import filenet.vw.api.VWExposedFieldDefinition;
import filenet.vw.api.VWRoster;
import filenet.vw.api.VWRosterDefinition;
import filenet.vw.api.VWSession;
import filenet.vw.base.VWDebug;
import filenet.vw.toolkit.admin.search.VWAdminPerformSearchEvent;
import filenet.vw.toolkit.admin.search.resources.VWResource;
import filenet.vw.toolkit.utils.VWStringUtils;
import filenet.vw.toolkit.utils.query.VWScopeChangeEvent;
import java.util.Vector;
import javax.swing.JOptionPane;

abstract class VWBaseSearchOptions {
    public static final int USERS_TAB = 1;
    public static final int FILTER_CONDITIONS_TAB = 2;
    public static final int SORT_BY_INDEX_TAB = 4;
    public static final int SELECT_COLUMNS_TAB = 8;
    public static final int ROSTERS_TAB = 16;
    public static final int QUEUES_TAB = 32;
    protected int m_nVisibleTabs = -1;
    protected String m_name = null;
    protected String m_selectedScope = null;
    protected String m_selectedSpecificScope = null;
    protected String m_workflowRosterItem = VWResource.s_workflowRoster;
    protected String m_workflowRostersItem = VWResource.s_workflowRosters;
    protected String m_queuesItem = VWResource.s_queues;
    protected String m_userQueueItem = VWResource.s_userQueue;
    protected String m_workQueueItem = VWResource.s_workQueue;
    protected String m_componentQueueItem = VWResource.s_componentQueue;
    protected String m_systemQueueItem = VWResource.s_systemQueue;
    protected String m_eventLogItem = VWResource.s_eventLog;
    protected String[] m_rosterNames = null;
    protected String[] m_queueNames = null;
    protected String[] m_userQueueNames = null;
    protected String[] m_workQueueNames = null;
    protected String[] m_componentQueueNames = null;
    protected String[] m_systemQueueNames = null;
    protected String[] m_eventLogNames = null;

    public String toString() {
        return this.m_name;
    }

    public abstract VWScopeChangeEvent createScopeChangeEvent(Object var1, VWSession var2);

    public VWAdminPerformSearchEvent createPerformSearchEvent(Object source) {
        VWAdminPerformSearchEvent event = null;
        try {
            event = new VWAdminPerformSearchEvent(source);
            if (event == null) {
                return null;
            }
            event.setResultType(this.getResultType());
            event.setScopeType(this.getScopeType());
            event.setSelectedItem(this.m_selectedSpecificScope);
            return event;
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
            return null;
        }
    }

    public final void setEventLogNames(String[] names) {
        this.m_eventLogNames = names;
    }

    public final String getName() {
        return this.m_name;
    }

    public abstract int getResultType();

    public final void setRosterNames(String[] names) {
        this.m_rosterNames = names;
    }

    public final void setQueueNames(String[] names) {
        this.m_queueNames = names;
    }

    public void setScope(String nItemName) {
        this.m_selectedScope = nItemName;
    }

    public int getScopeType() {
        if (VWStringUtils.compare(this.m_selectedScope, this.m_workflowRostersItem) == 0) {
            return 1;
        }
        if (VWStringUtils.compare(this.m_selectedScope, this.m_workflowRosterItem) == 0) {
            return 1;
        }
        if (VWStringUtils.compare(this.m_selectedScope, this.m_queuesItem) == 0) {
            return 2;
        }
        if (VWStringUtils.compare(this.m_selectedScope, this.m_userQueueItem) == 0) {
            return 3;
        }
        if (VWStringUtils.compare(this.m_selectedScope, this.m_workQueueItem) == 0) {
            return 4;
        }
        if (VWStringUtils.compare(this.m_selectedScope, this.m_componentQueueItem) == 0) {
            return 5;
        }
        if (VWStringUtils.compare(this.m_selectedScope, this.m_systemQueueItem) == 0) {
            return 6;
        }
        if (VWStringUtils.compare(this.m_selectedScope, this.m_eventLogItem) == 0) {
            return 7;
        }
        return -1;
    }

    public abstract String[] getScopeOptions();

    public void setSpecificScope(String nItemName) {
        this.m_selectedSpecificScope = nItemName;
    }

    public abstract String[] getSpecificScopeOptions();

    public final void setSystemQueueNames(String[] names) {
        this.m_systemQueueNames = names;
    }

    public final void setUserQueueNames(String[] names) {
        this.m_userQueueNames = names;
    }

    public final int getVisibleTabs() {
        return this.m_nVisibleTabs;
    }

    public final void setVisibleTabs(int nTabs) {
        this.m_nVisibleTabs = nTabs;
    }

    public final void setWorkQueueNames(String[] names) {
        this.m_workQueueNames = names;
    }

    public final void setComponentQueueNames(String[] names) {
        this.m_componentQueueNames = names;
    }

    protected VWScopeChangeEvent createRosterScopeChangeEvent(Object source, VWSession session) {
        VWRoster vwRoster = null;
        VWRosterDefinition vwRosterDef = null;
        VWScopeChangeEvent scEvent = null;
        try {
            if (this.m_selectedSpecificScope == null) {
                return null;
            }
            if (session != null) {
                try {
                    vwRoster = session.getRoster(this.m_selectedSpecificScope);
                    vwRosterDef = vwRoster.fetchRosterDefinition();
                }
                catch (Exception ex) {
                    VWDebug.logException(ex);
                    JOptionPane.showMessageDialog(null, ex.getLocalizedMessage(), VWResource.s_errorMessage, 0);
                }
            }
            scEvent = new VWScopeChangeEvent(source);
            scEvent.setType(1);
            scEvent.setDefinitionObject(vwRosterDef);
            scEvent.setDefaultColumns(this.getDefaultColumns(vwRosterDef));
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
        return scEvent;
    }

    protected String[] getDefaultColumns(IVWTableDefinition definition) {
        Vector columnNames = null;
        Object[] names = null;
        try {
            columnNames = new Vector();
            this.getSystemFieldNames(columnNames, definition);
            this.getUserDefinedFieldNames(columnNames, definition);
            names = new String[columnNames.size()];
            columnNames.copyInto(names);
            return names;
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
            return null;
        }
    }

    protected void getSystemFieldNames(Vector names, IVWTableDefinition definition) {
        VWExposedFieldDefinition[] fields = null;
        String fieldName = null;
        try {
            if (definition == null) {
                return;
            }
            fields = definition.getFields();
            for (int i = 0; i < fields.length; ++i) {
                if (!fields[i].isSystemField()) continue;
                fieldName = fields[i].getAuthoredName();
                if (VWStringUtils.compare(fieldName, "F_Originator") == 0 || VWStringUtils.compare(fieldName, "F_WobNum") == 0 || VWStringUtils.compare(fieldName, "F_WorkFlowNumber") == 0 || VWStringUtils.compare(fieldName, "F_BoundUser") == 0 || VWStringUtils.compare(fieldName, "F_LockUser") == 0 || VWStringUtils.compare(fieldName, "F_StartTime") == 0 || VWStringUtils.compare(fieldName, "F_Subject") == 0 || VWStringUtils.compare(fieldName, "F_Operation") == 0 || VWStringUtils.compare(fieldName, "F_Comment") == 0 || VWStringUtils.compare(fieldName, "F_Response") == 0 || VWStringUtils.compare(fieldName, "F_LockTime") == 0) {
                    names.addElement(fields[i].getName());
                }
                if (this.getScopeType() != 7 || VWStringUtils.compare(fieldName, "F_BoundUserId") != 0 && VWStringUtils.compare(fieldName, "F_EventType") != 0 && VWStringUtils.compare(fieldName, "F_SeqNumber") != 0 && VWStringUtils.compare(fieldName, "F_OperationId") != 0) continue;
                names.addElement(fields[i].getName());
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    protected void getUserDefinedFieldNames(Vector names, IVWTableDefinition definition) {
        VWExposedFieldDefinition[] fields = null;
        String fieldName = null;
        try {
            if (definition == null) {
                return;
            }
            fields = definition.getFields();
            for (int i = 0; i < fields.length; ++i) {
                if (fields[i].isSystemField()) continue;
                fieldName = fields[i].getName();
                names.addElement(fieldName);
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }
}

